(function () {
    document.addEventListener('DOMContentLoaded', () => {
        const nameInputs = document.querySelectorAll('[name="name"]');
        const phoneInputs = document.querySelectorAll('[name="phone"]');

        const validateInput = (input, regex) => {
            input.value = input.value.split('').filter(char => regex.test(char)).join('');
        }
        if (window.validationName) {
            nameInputs.forEach(name => {
                name.addEventListener('input', () => {
                    validateInput(name, /^[\p{L} ]+$/u);
                })
            })
        }

        if (window.validationPhone) {
            phoneInputs.forEach(phone => {
                phone.addEventListener('input', () => {
                    validateInput(phone, /^\+?\d*$/);
                })
            })
        }

    })
})();
