(function () {
    function appendInputToForm(form, name, value) {
        var children = form.children;
        if (typeof value === "object") value = JSON.stringify(value);
        for (var item = 0; item < children.length; item++) {
            if (children[item].getAttribute("name") === name) {
                children[item].value = value;
                return false;
            }
        }
        var input = document.createElement("input");
        input.type = "hidden";
        input.name = name;
        input.value = value;
        form.appendChild(input);
        return true;
    }

    function appendInputToAllForms(name, value) {
        var forms = document.getElementsByTagName("form");
        for (var form = 0; form < forms.length; form++) {
            appendInputToForm(forms[form], name, value);
        }
    }

    function findGetParameter(item) {
        var result = "", items = [];
        var query = location.search.substr(1).split("&");
        for (var i = 0; i < query.length; i++) {
            items = query[i].split("=");
            if (items[0] === item) result = decodeURIComponent(items[1]);
        }
        return result;
    }

    function makeAndAppendClick() {
        if (!!sessionStorage.getItem('kma-click')) {
            return appendInputToAllForms("click", sessionStorage.getItem('kma-click'));
        }
        var queryObject = {
            'data1': findGetParameter('d1') || findGetParameter('data1') || findGetParameter('utm_source'),
            'data2': findGetParameter('d2') || findGetParameter('data2') || findGetParameter('utm_medium'),
            'data3': findGetParameter('d3') || findGetParameter('data3') || findGetParameter('utm_campaign'),
            'data4': findGetParameter('d4') || findGetParameter('data4') || findGetParameter('utm_content'),
            'data5': findGetParameter('d5') || findGetParameter('data5') || findGetParameter('utm_term'),
            'fbp': findGetParameter('fbp'),
            'fbclid': findGetParameter('fbclid'),
        };
        var queryArray = [];
        for (var key in queryObject) {
            queryObject[key] && queryArray.push(key + '=' + queryObject[key]);
        }
        var xhr = new XMLHttpRequest();
        xhr.open('GET', 'api/success.php?' + queryArray.join('&'), true);
        xhr.setRequestHeader('X-Kma-Api', 'click');
        if (!!document.referrer) xhr.setRequestHeader('X-Referer', document.referrer);
        xhr.send();
        xhr.onload = function () {
            var array;
            try {
                array = JSON.parse(this.response);
            } catch (e) {
                return;
            }
            console.log(array.click);
            if (array.click === undefined) return;
            sessionStorage.setItem('kma-click', array.click);
            appendInputToAllForms('click', array.click);
        };
    }

    makeAndAppendClick();

    function copyUrlQueryToFormInput() {
        var includeQueryKeys = ['fbc', 'fbclid'];
        var queryString = location.search.slice(1);
        if (!queryString) {
            return;
        }
        queryString.split('&').forEach(function (param) {
            var [key, value] = param.split('=');
            var decodedKey = decodeURIComponent(key || '');
            var decodedValue = decodeURIComponent(value || '');
            if (includeQueryKeys.includes(decodedKey)) {
                appendInputToAllForms(decodedKey, decodedValue);
            }
        });
    }

    copyUrlQueryToFormInput();

    function submitHandler() {
        var excludeInputNames = ['name', 'phone', 'address', 'client_data'];
        var data = $(this).serializeArray().filter(function (input) {
            return -1 === excludeInputNames.indexOf(input.name);
        });
        appendInputToForm(this, 'address', JSON.stringify(data));
    }

    document.querySelectorAll("form").forEach(function (item) {
        item.addEventListener("submit", submitHandler, true);
    })
}());
